//
//  main.m
//  testProduct
//
//  Created by 斌 on 14-3-5.
//  Copyright (c) 2014年 斌. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "Dog.h"//引入頭，參考 [obj-c]入門(一)

int main(int argc, const char * argv[])
{

    @autoreleasepool {
        
        // insert code here...
        NSLog(@"Hello, World!");
        
        //輸出 類方法 的返回值，這裡可以看到類方法是不需要實例化。
        NSLog(@"%@",[Dog getObjectName]);
        
        //下面將實例化啊，a,b,c三個對象，都是屬於Dog類
        
        // a 對象
        Dog *a; //a是一個Dog類型的對象;//關於 * 星號，表明對象的引用（指針）
        //此時 a 並沒有存儲數據，而是存儲了一個內存地址，我們可以認為他是個盒子。
        
        a = [Dog alloc]; //alloc,則是分配新內存存儲空間；
        //此時內存中會保留足夠空間用於存儲對象數據，包括實例變量的空間。
        
        a = [a init]; //init,用於初始化類的實例變量；
        
        
        // b 對象
        //當然一般情況，我們會用把alloc和init直接合併到聲明行，簡寫如下:
        Dog *b = [[Dog alloc] init];
        
        // c 對象
        //當然還有另一種，new的方法可以將alloc和init的操作結合起來，如下:
        Dog *c = [Dog new];
    
        //設置 food 參數
        [a setFood:@"蘋果"];
        
        [b setFood:@"香蕉"];
        
        [c setFood:@"梨子"];
        
        //打印 food 參數
        [a getFood];
        
        [b getFood];
        
        [c getFood];

    }
    return 0;
}

