//
//  main.m
//  testProduct
//
//  Created by 斌 on 14-3-5.
//  Copyright (c) 2014年 斌. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "Dog.h"//引入頭，參考 [obj-c]入門(一)


void section1(){
    //章节一
    NSLog(@"Hello, World!");
    
}

void section2(){
    //輸出 類方法 的返回值，這裡可以看到類方法是不需要實例化。
    NSLog(@"%@",[Dog getObjectName]);
    
    //下面將實例化啊，a,b,c三個對象，都是屬於Dog類
    
    // a 對象
    Dog *a; //a是一個Dog類型的對象;//關於 * 星號，表明對象的引用（指針）
    //此時 a 並沒有存儲數據，而是存儲了一個內存地址，我們可以認為他是個盒子。
    a = [Dog alloc]; //alloc,則是分配新內存存儲空間；
    //此時內存中會保留足夠空間用於存儲對象數據，包括實例變量的空間。
    a = [a init]; //init,用於初始化類的實例變量；
    
    // b 對象
    //當然一般情況，我們會用把alloc和init直接合併到聲明行，簡寫如下:
    Dog *b = [[Dog alloc] init];
    
    // c 對象
    //當然還有另一種，new的方法可以將alloc和init的操作結合起來，如下:
    Dog *c = [Dog new];
    
    //設置 food 參數
    [a setFood:@"蘋果"];
    [b setFood:@"香蕉"];
    [c setFood:@"梨子"];
    
    //打印 food 參數
    [a getFood];
    [b getFood];
    [c getFood];
    
}

void section3(){
    
    int i = 1;  //整型
    float f = 1.01;//浮点型
    double d = 1.01e10;//双精度浮点型
    char myChar = 'A';//单个字符
    
    //输出格式符
    NSLog (@"int = %i",i);//整型：%i %d %x %o
    NSLog (@"float = %f",f);//浮点：%f %e %g %a
    NSLog (@"double = %g",d);
    NSLog (@"double = %f",d);
    NSLog (@"char = %c",myChar);//字符：%c
    
    printf("\n");// \n 为换行符
    NSLog(@"0144 = %d",0144);//八进制的100，可以用%o输出八进制
    NSLog(@"0x64 = %d",0x64);//十六进制的100，可以用%x输出十六进制
    
    
    printf("\n");
    //算数表达式
    //二元运算符
    int x = 5 ,y = 2;
    NSLog(@"5 + 2 = %i",x + y);//加
    NSLog(@"5 - 2 = %i",x - y);//减
    NSLog(@"5 * 2 = %i",x * y);//乘
    NSLog(@"5 / 2 = %i",x / y);//除
    NSLog(@"5 %% 2 = %i",x % y);//模，取余
    
    printf("\n");
    //整型 && 浮点 类型转换
    int z = 3.141592654;
    float t = 1;
    NSLog(@"z = %d , t = %f",z,t);
    NSLog(@"5 / 2.0f = %0.1f",x / 2.0f );
    //类型转换
    NSLog(@"5 / 2 = %f",(float)x / y );
    
    printf("\n");
    //运算符优先级
    NSLog(@"5 + 2 * 2 = %i",x + y * y);//乘法优先加法
    NSLog(@"5 / 5 - 2 / 2 = %i",x / x - y / y );//除法优先减法
    NSLog(@"5 %% 2 * 2 = %i",x % y * y );//模与乘除一样
    //括号是可以改变运算顺序的：
    NSLog(@"5 * (5 - 2) / 2 = %i",x * (x - y) / y );
    NSLog(@"5 %% (2 * 2) = %i",x % (y * y) );
    
    printf("\n");
    //一元运算符
    //如： 逻辑非 ！  自增 ++  自减 --  一元减 - 按位求反 ～
    NSLog(@"!0 = %i , !1 = %i",!0,!1);
    //" !0" 这个逻辑表达式的值为1.(判断的这个数为0,成立,则其表达式的值为1)
    //" !1" 这个逻辑表达式的值为0.(判断的这个数非0,不成立,则其表达式的值为0)
    
    //一元减
    NSLog(@"-i : %i",-i);
    
    //自增 && 自减
    NSLog(@"i = %i",i);
    NSLog(@"++i : %i",++i);
    NSLog(@"--i : %i",--i);
    
    //i++ && ++i 区别
    NSLog(@"i = %i",i);
    NSLog(@"i++ : %i",i++);
    NSLog(@"i-- : %i",i--);
    
    /*首先不管i++，还是++i都是i=i+1的意思,
     区别在于i++是i先不自加，在语句完后自加,
     而++i先自加，再执行语句。*/
    
    //按位求反 ～
    NSLog(@"~0 : %d",~0);
    //即将0变1，将1变0
    //至于为啥是-1，这关系到符号位
    
    
    printf("\n");
    //赋值运算
    NSLog(@"i = %i",i);
    NSLog(@"i += : %i",i += 2);//等价于 i = i + 2;
    NSLog(@"i -= : %i",i -= 2);//等价于 i = i - 2;
    
    NSLog(@"i = %i , x ＝ %d , y = %d",i,x,y);
    NSLog(@"1 - x + y : %i",1 - x + y);
    NSLog(@"1 - (x + y) : %i",1 - (x + y));
    NSLog(@"i -= x + y : %i",i -= x + y);//等价于 i = i - (x + y);
    
}

void section4(){

    //if-else
    if ( 1 + 1 == 2)
        NSLog(@"你是对的！");//满足条件，执行部分
    else
        NSLog(@"你算错了！");//不满足条件，执行部分
    
    
    //switch
    int i = 0;
    switch (i) {
        case 0:
            NSLog(@"i ＝ 0");//当i＝0，执行部分
            break;
        case 1:
            NSLog(@"i ＝ 1");//当i＝1，执行部分
            break;
        case 2:
            NSLog(@"i ＝ 2");//当i＝2，执行部分
            break;
        default:
            NSLog(@"i ＝ %d",i);//当i不等于以上条件，执行部分
            break;
    }
    
    //三目
    BOOL results = ( 1 + 1 == 2 ? YES : NO);
    NSLog(@"results = %d",results);
    
}

void section5(){
    
    
    
}

int main(int argc, const char * argv[])
{

    @autoreleasepool {
        
//        section1();//[obj-c]入門(一)
//        section2();//[obj-c]類，對象，方法(二)
//        section3();//[obj-c]数据类型，算数表达式（三） 
//        section4();//[obj-c]分支结构（四）

        int x = 0;
        x = 1 + 2 + 3 + 4 + 5;
        NSLog(@"1 + 2 + 3 + 4 + 5 = %d",x);
        
        x = ( 1 + 100 ) * ( 100 / 2 );
        NSLog(@"1 + 2 + 3 + 4 + 5 ... + 100 = %d",x);
        
        int n = 0;
        printf("\n请点击控制台，输入 n 值，并回车 _> ");
        scanf("%i",&n);//【注意】C语言的字符串，是不需要@
        //&字符,是指定输入的值存储在哪。
        printf("\n");
        NSLog(@"n = %d",n);
        
        x = ( n % 2 == 1 ? ( 1 + ( n - 1 ) ) * ( ( n - 1 ) / 2 ) + n : ( 1 + n ) * ( n / 2 ) );
        NSLog(@"1 + 2 + 3 + 4 + 5 ... + n = %d",x);
        
        
        x = 0;
        // for ( 初始表达式值 ；循环条件 ；完成循环体后执行语句)
        for (int i = 0; i <= n; i++) {
            //这里变量 i 在for循环中处于局部变量，并不能在for外部被使用。
            x += i;//循环体
        }
        NSLog(@"[for] 1 + 2 + 3 + 4 + 5 ... + n = %d",x);
        printf("\n");
        
        
        x = 0;
        int i = 0;
        for (; i <= n ; x += i , i++)
            NSLog(@"i = %d , x = %d",i,x);//没有大括号下，for将把下一行当成循环语句
        NSLog(@"[for] 1 + 2 + 3 + 4 + 5 ... + n = %d",x);
        printf("\n");
        
        x = 0 , i = 0;
        while (i <= n){//条件为真，执行循环体
            x += i;
            i++;
        }
        NSLog(@"[while] 1 + 2 + 3 + 4 + 5 ... + n = %d",x);
        printf("\n");
        
        
        
        x = 0 , i = 0;
        while (x < 0){
            x++;
            NSLog(@"[while]");
        }
        
        do{//优先走一次循环体
            i++;
            NSLog(@"[do while]");
        }while (i < 0);//进行条件判断，为真则再循环。
        NSLog(@"x = %d ,i = %d",x,i);
        printf("\n");
        
        x = 0 , i = 0;
        while (x < 3){
            x++;
            
            if (x == 2) {
                continue;//跳出本次循环
            }
            NSLog(@"[continue] x = %d",x);
        }
        
        while (i < 3){
            i++;
            
            if (i == 2) {
                break;//跳出整个循环
            }
            NSLog(@"[break] i = %d",i);
        }
        

        printf("\n");
    }
    return 0;
}




