//
//  ViewController.m
//  Demo1219
//
//  Created by 斌 on 14/12/19.
//  Copyright (c) 2014年 KumaDocs. All rights reserved.
//

#import "ViewController.h"
#import <CoreLocation/CoreLocation.h>

@interface ViewController ()<CLLocationManagerDelegate>{
    
    CLLocationManager *locManager;
}

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    locManager=[[CLLocationManager alloc]init]; //创建位置管理器
    locManager.delegate=self;//设置代理
    locManager.desiredAccuracy=kCLLocationAccuracyBest; //指定需要的精度级别
    locManager.distanceFilter=100; //设置距离筛选器
    if ([[[UIDevice currentDevice] systemVersion] doubleValue] > 8.0)
    {
        //设置定位权限
//        [locManager requestWhenInUseAuthorization];//使用期间
        [locManager requestAlwaysAuthorization];//始终
        
        
    }
    [locManager startUpdatingLocation]; //启动更新位置管理
    
}

- (IBAction)btnAction:(id)sender {
    CLLocationDegrees latitude = locManager.location.coordinate.latitude; //float也行，获取当前位置的纬度
    CLLocationDegrees longitude = locManager.location.coordinate.longitude; //float也行，获取当前位置的经度
    NSLog(@"latitude %f",latitude);
    NSLog(@"longitude %f",longitude);
    
    if (longitude == latitude && latitude == 0) {
        NSLog(@"定位失败");
        [self alertWithMsg:@"定位失败"];
    }else{
        
        CLGeocodeCompletionHandler handler = ^(NSArray *place, NSError *error) {
            
            for (CLPlacemark *placemark in place) {
                
                NSString *country=[placemark.addressDictionary objectForKey:@"Country"];
                
                NSLog(@"Country %@",country);//国家
                
                NSString *state=[placemark.addressDictionary objectForKey:@"State"];
                
                NSLog(@"State %@",state);//省份
                
                NSString *city=[placemark.addressDictionary objectForKey:@"City"];
                
                NSLog(@"city %@",city);//城市
                
                NSString *street=[placemark.addressDictionary objectForKey:@"Street"];
                
                NSLog(@"Street %@",street);//街道
                
                NSString *addr=[NSString stringWithFormat:@"%@ %@ %@ %@",country,state,city,street];
                
                NSLog(@"addr %@",addr);
                
                [(UIButton*)sender setTitle:addr forState:UIControlStateNormal];
                
                break;
                
            }
            
        };
        
        //反向地理编码
        CLGeocoder *Geocoder=[[CLGeocoder alloc]init];
        CLLocation *loc = [[CLLocation alloc] initWithLatitude:latitude longitude:longitude];
        [Geocoder reverseGeocodeLocation:loc completionHandler:handler];
        
    }
    
}

#pragma mark - CLLocationManagerDelegate
- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status{
    
    switch (status) {
            
        case kCLAuthorizationStatusNotDetermined:
            
            //使用期间
            //            if ([manager respondsToSelector:@selector(requestWhenInUseAuthorization)])
            //            {
            //                [manager requestWhenInUseAuthorization];
            //
            //            }
            
            //始终
            if ([manager respondsToSelector:@selector(requestAlwaysAuthorization)])
            {
                [manager requestAlwaysAuthorization];
                
            }
            
            break;
            
        default:
            
            break;
            
    }
    
}


- (void)alertWithMsg:(NSString *)msg{
    
    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:msg message:nil delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
    [alert show];
    
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
