//
//  ViewController.m
//  TouchID
//
//  Created by 斌 on 14/12/10.
//  Copyright (c) 2014年 kumaDocs. All rights reserved.
//

#import "ViewController.h"
#import <LocalAuthentication/LocalAuthentication.h>
@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (IBAction)btnAction:(id)sender {
    
    if ([[[UIDevice currentDevice] systemVersion] doubleValue] > 8.0)
    {
        LAContext *context = [LAContext new];
        
        NSError *error;
        context.localizedFallbackTitle = @"手输密码";//回退按钮。为nil，则显示“输入密码”。不使用就直接这样。
        
        if ([context canEvaluatePolicy:LAPolicyDeviceOwnerAuthenticationWithBiometrics error:&error]) {
            
            [context evaluatePolicy:LAPolicyDeviceOwnerAuthenticationWithBiometrics localizedReason:@"请用指纹识别来验证" reply:^(BOOL success, NSError *error) {
                
                if (success) {
                    [self alertWithMsg:@"识别成功"];
                    
                } else {
                    if (error.code == kLAErrorUserFallback) {
                        [self alertWithMsg:@"用户手输密码"];
                    } else if (error.code == kLAErrorUserCancel) {
                        [self alertWithMsg:@"用户取消"];
                    } else {
                        [self alertWithMsg:@"验证失败"];
                    }
                }
            }];
            
        } else {
            [self alertWithMsg:@"您的设备不支持Touch ID，请输入密码"];
        }
        
    }else{
        [self alertWithMsg:@"您的设备不支持Touch ID，请输入密码"];
    }

}





- (void)alertWithMsg:(NSString *)msg{
    
    //注意，不回主线程，会导致等了很久才出AlertView。
    dispatch_async(dispatch_get_main_queue(), ^{
    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:msg message:nil delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
        [alert show];
    });
    
}

@end
