//
//  ViewController.swift
//  sqlite
//
//  Created by 斌 on 15/1/2.
//  Copyright (c) 2015年 KumaDocs. All rights reserved.
//

import UIKit

let kDBName = "studentInfo.sqlite"
let kTableName = "STUDENT_INFO"

let NAME = "name"
let AGE = "age"
let SID = "sid"

class ViewController: UIViewController {

    var db : COpaquePointer = nil
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        //打开/创建数据库
        self.openSql()
        
        //创建表
        let sql0 : NSString = NSString(format:"CREATE TABLE IF NOT EXISTS %@ (ID INTEGER PRIMARY KEY AUTOINCREMENT, %@ TEXT, %@ INTEGER, %@ TEXT)", kTableName, NAME, AGE, SID)
        self.execSql(sql0)

        //插入数据
        let sql1 : NSString = NSString(format:"INSERT INTO '%@' ('%@', '%@', '%@') VALUES ('%@', '%@', '%@')", kTableName, NAME, AGE, SID, "张三", "10", "4008123123")
        let sql2 : NSString = NSString(format:"INSERT INTO '%@' ('%@', '%@', '%@') VALUES ('%@', '%@', '%@')",kTableName, NAME, AGE, SID, "李四", "20", "4008123124")
        
        self.execSql(sql1)
        self.execSql(sql2)
        
        //查询
        let sql4 : NSString = "SELECT * FROM ".stringByAppendingString(kTableName)
        var statement = self.querySql(sql4)
        if (statement != nil){
            while (sqlite3_step(statement) == SQLITE_ROW) {
                
                let name = UnsafePointer<CChar>(sqlite3_column_text(statement, 1))
                var nameStr : NSString = NSString(UTF8String: name)!
                
                var age : Int = Int(sqlite3_column_int(statement, 2))
                
                let sid = UnsafePointer<CChar>(sqlite3_column_text(statement, 3))
                var sidStr : NSString = NSString(UTF8String: sid)!
                
                NSLog("%@:%@ %@:%d %@:%@",NAME,nameStr,AGE,age,SID,sidStr);
                
            }
        }
        
        // Do any additional setup after loading the view, typically from a nib.
    }

    //打开数据库
    func openSql(){
    
        var paths : NSArray = NSSearchPathForDirectoriesInDomains(.DocumentDirectory, .UserDomainMask, true)
        var documents : NSString = paths.objectAtIndex(0) as NSString
        var database_path : NSString = documents.stringByAppendingPathComponent(kDBName)
        
        NSLog("数据库路径 : %@", database_path)
        
        if (sqlite3_open(database_path.UTF8String, &db) != SQLITE_OK) {
            self.closeSql()
            NSLog("数据库打开失败")
        }
    }
    
    //关闭数据库
    func closeSql(){
        if sqlite3_close(db) != SQLITE_OK {
            NSLog("数据库打开失败")
        }
    }
    
    //执行语句
    func execSql(sql : NSString){
        if (sqlite3_exec(db, sql.UTF8String, nil, nil, nil) != SQLITE_OK) {
            self.closeSql()
            NSLog("数据库操作数据失败!")
        }
        
    }
    
    //查询
    func querySql(sql : NSString) -> COpaquePointer {
        
        var statement : COpaquePointer = nil
        
        if (sqlite3_prepare_v2(db, sql.UTF8String, -1, &statement, nil) == SQLITE_OK) {
            
            return statement
        
        }
        self.closeSql()
        return nil
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

